package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "REQUESTS")
public class Request implements Serializable {

	private static final long serialVersionUID = 3793516344200606259L;
	private static Log log = LogFactory.getLog(Request.class);

	@Id
	@Column(name = "REQUEST_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "INACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isInactive = Boolean.FALSE;

	@Column(name = "MAX_EXCEEDED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean exceededMaxFailedAttempts;

	@Column(name = "START_DATE_ARGUMENT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date startDate;

	@Column(name = "USER_ID_SEQ")
	private Long userId;

	//@ManyToOne(fetch = FetchType.EAGER)
	//@JoinColumn(name = "USER_ID_SEQ")
	//private UserProfile userProfile;

	@Column(name = "REQUEST_FUNCTION")
	private Integer requestFunction;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "STATUS")
	private String status;

	@Column(name = "END_DATE_ARGUMENT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date endDate;

	@Column(name = "INSTITUTION_ID", insertable = false, updatable = false)
	private Long institutionId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "INSTITUTION_ID")
	private Institution institution;

	@OneToMany(mappedBy = "parentPharmacyPatient", fetch = FetchType.EAGER)
	@Fetch(FetchMode.SELECT)
	private Set<PharmPatientChange> pharmacyPatientChanges;

	@OneToMany(mappedBy = "parentRequest", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@Fetch(FetchMode.SELECT)
	private Set<PrescriptionRequest> prescriptionRequests;

	@OneToMany(mappedBy = "parentRequest", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@Fetch(FetchMode.SELECT)
	private Set<RequestAttempt> requestAttempts;

	public Long getId() {
		return id;
	}

	public void setId(Long requestId) {
		this.id = requestId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Boolean getIsInactive() {
		return isInactive;
	}

	public void setIsInactive(Boolean isInactive) {
		this.isInactive = isInactive;
	}

	public Boolean getExceededMaxFailedAttempts() {
		return exceededMaxFailedAttempts;
	}

	public void setExceededMaxFailedAttempts(Boolean exceededMaxFailedAttempts) {
		this.exceededMaxFailedAttempts = exceededMaxFailedAttempts;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	/*public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}*/

	public Integer getRequestFunction() {
		return requestFunction;
	}

	public void setRequestFunction(Integer requestFunction) {
		this.requestFunction = requestFunction;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Long getInstitutionId() {
		return institutionId;
	}

	public void setInstitutionId(Long institutionId) {
		this.institutionId = institutionId;
	}

	public Institution getInstitution() {
		return institution;
	}

	public void setInstitution(Institution institution) {
		this.institution = institution;
	}

	public Set<PharmPatientChange> getPharmacyPatientChanges() {
		return pharmacyPatientChanges;
	}

	public void setPharmacyPatientChanges(
			Set<PharmPatientChange> pharmacyPatientChanges) {
		this.pharmacyPatientChanges = pharmacyPatientChanges;
	}

	public Set<PrescriptionRequest> getPrescriptionRequests() {
		return prescriptionRequests;
	}

	public void setPrescriptionRequests(
			Set<PrescriptionRequest> prescriptionRequests) {
		this.prescriptionRequests = prescriptionRequests;
	}

	public Set<RequestAttempt> getRequestAttempts() {
		return requestAttempts;
	}

	public void setRequestAttempts(Set<RequestAttempt> requestAttempts) {
		this.requestAttempts = requestAttempts;
	}

	/**
	 * Add a requestAttempt
	 *
	 * @param The requestAttempt to add
	 */
	public void addRequestAttempt(RequestAttempt requestAttempt) {
		Set<RequestAttempt> childSet = getRequestAttempts();
		if (childSet == null) {
			childSet = new HashSet<RequestAttempt>();
			setRequestAttempts(childSet);
		}

		requestAttempt.setParentRequest((Request) this );
		childSet.add( requestAttempt );
	}

	/**
	 * Remove a requestAttempt
	 *
	 * @param The requestAttempt to remove
	 */
	public RequestAttempt removeRequestAttempt(RequestAttempt requestAttempt) {
		if( getRequestAttempts().remove( requestAttempt ) ) {
			requestAttempt.setParentRequest(null);
		} else {
			log.error("Could not remove requestAttempt instance with key " + requestAttempt.getId());
		}

		return requestAttempt;
	}

	/**
	 * Add a prescriptionRequest
	 *
	 * @param The prescriptionRequest to add
	 */
	public void addPrescriptionRequest(PrescriptionRequest prescriptionRequest) {
		if (log.isDebugEnabled()) {
					log.debug(" 70f >>>>>>>>>>>> addPrescriptionRequest");
		}

		Set<PrescriptionRequest> childSet = getPrescriptionRequests();

		if (childSet == null) {

			if (log.isDebugEnabled()) {
						log.debug(" 70g >>>>>>>>>>>> childSet is null .");
			}

			childSet = new HashSet<PrescriptionRequest>();
			setPrescriptionRequests(childSet);
		}

		prescriptionRequest.setParentRequest( (Request) this );
		childSet.add( prescriptionRequest );
/*
		prescriptionRequest.setParentRequest(this);
        this.prescriptionRequests.add(prescriptionRequest);
*/

	}

	/**
	 * Remove a prescriptionRequest
	 *
	 * @param The prescriptionRequest to remove
	 */
	public PrescriptionRequest removePrescriptionRequest(PrescriptionRequest prescriptionRequest) {
		if( getPrescriptionRequests().remove( prescriptionRequest ) ) {
			prescriptionRequest.setParentRequest(null);
		} else {
			log.error("Could not remove prescriptionRequest instance with key " + prescriptionRequest.getId());
		}

		return prescriptionRequest;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();

		sb.append("id : " + id);
		sb.append(", oplock : " + oplock);
		sb.append(", createdDate : " + createdDate);
		sb.append(", status : " + status);
		sb.append(", modifiedDate : " + modifiedDate);
		sb.append(", userId : " + userId);

		return sb.toString();
	}
}
